@echo off
REM BHR Battery Diagnostics Tool - Firmware Flasher for Windows
REM Requires: Python 3 and esptool installed (pip install esptool)

echo ===============================================
echo BHR Battery Diagnostics - Firmware Flasher
echo ===============================================
echo.

REM Check if Python is installed
python --version >nul 2>&1
if errorlevel 1 (
    echo ERROR: Python is not installed or not in PATH
    echo Please install Python 3 from https://www.python.org/
    echo.
    pause
    exit /b 1
)

REM Check if esptool is installed
python -m esptool version >nul 2>&1
if errorlevel 1 (
    echo esptool not found. Installing...
    pip install esptool
    if errorlevel 1 (
        echo ERROR: Failed to install esptool
        pause
        exit /b 1
    )
)

echo.
echo Available COM ports:
python -m serial.tools.list_ports
echo.

REM Prompt for COM port
set /p COMPORT="Enter COM port (e.g., COM3): "

if "%COMPORT%"=="" (
    echo ERROR: No COM port specified
    pause
    exit /b 1
)

echo.
echo Flashing firmware to %COMPORT%...
echo Please make sure your ESP32 is connected and no other program is using the port.
echo.

REM Flash the firmware
python -m esptool --chip esp32 --port %COMPORT% --baud 460800 write_flash ^
    0x1000 firmware\bootloader.bin ^
    0x8000 firmware\partitions.bin ^
    0xe000 firmware\boot_app0.bin ^
    0x10000 firmware\firmware.bin

if errorlevel 1 (
    echo.
    echo ERROR: Flashing failed!
    echo Make sure:
    echo  1. ESP32 is connected to %COMPORT%
    echo  2. No other program (like Arduino IDE or serial monitor) is using the port
    echo  3. You selected the correct COM port
    echo.
    pause
    exit /b 1
)

echo.
echo ===============================================
echo SUCCESS! Firmware flashed successfully!
echo ===============================================
echo.
echo You can now disconnect and reconnect your device.
echo Use a serial monitor at 115200 baud to communicate with the device.
echo.
pause
