# BHR Battery Diagnostics Tool - Firmware Flashing Instructions

## Quick Start

### Windows Users
1. **Double-click** `flash_firmware_windows.bat`
2. Enter your COM port when prompted (e.g., COM3)
3. Wait for flashing to complete

### Linux/Mac Users
1. **Make script executable:** `chmod +x flash_firmware_linux.sh`
2. **Run:** `./flash_firmware_linux.sh`
3. Enter your serial port when prompted (e.g., /dev/ttyUSB0)
4. May need sudo: `sudo ./flash_firmware_linux.sh`

---

## Prerequisites

- **Python 3** installed ([Download](https://www.python.org/downloads/))
- **USB driver** for ESP32 (CP2102 or CH340 driver depending on your board)
- **USB cable** connected to your ESP32

The flash scripts will automatically install `esptool` if not present.

---

## Finding Your COM Port

### Windows
1. Open Device Manager
2. Expand "Ports (COM & LPT)"
3. Look for "Silicon Labs CP210x" or "USB-SERIAL CH340" with COM number

### Linux
Run: `ls /dev/ttyUSB*` or `ls /dev/ttyACM*`

### Mac
Run: `ls /dev/cu.*`

---

## Manual Flashing (Advanced)

If the automated scripts don't work, you can flash manually:

### Install esptool
```bash
pip install esptool
```

### Flash Command
```bash
esptool.py --chip esp32 --port YOUR_PORT --baud 460800 write_flash \
    0x1000 firmware/bootloader.bin \
    0x8000 firmware/partitions.bin \
    0xe000 firmware/boot_app0.bin \
    0x10000 firmware/firmware.bin
```

Replace `YOUR_PORT` with your actual port (COM3, /dev/ttyUSB0, etc.)

---

## Alternative Method: ESP Flash Download Tool (Windows Only)

1. **Download** [ESP Flash Download Tools](https://www.espressif.com/en/support/download/other-tools)
2. **Run** the tool and select "ESP32 DownloadTool"
3. **Configure:**
   - firmware/bootloader.bin @ 0x1000
   - firmware/partitions.bin @ 0x8000
   - firmware/boot_app0.bin @ 0xe000
   - firmware/firmware.bin @ 0x10000
4. **Select** your COM port
5. **Click** START

---

## Web-based Flasher (No Installation Required)

Open `web_flasher.html` in Chrome or Edge browser for a simple click-and-flash experience.

---

## Troubleshooting

### "Failed to connect"
- Press and hold the BOOT button on your ESP32, then click "START"
- Try a different USB cable (some cables are power-only)
- Reduce baud rate to 115200 in the command

### "Permission denied" (Linux/Mac)
- Run with sudo: `sudo ./flash_firmware_linux.sh`
- Or add your user to dialout group: `sudo usermod -a -G dialout $USER`

### "Port already in use"
- Close Arduino IDE, PlatformIO, or any serial monitor
- Unplug and replug the USB cable

### "Chip not found"
- Check USB cable connection
- Install correct USB driver (CP2102 or CH340)
- Try a different USB port

---

## After Flashing

1. **Disconnect and reconnect** the USB cable
2. **Open a serial monitor** at 115200 baud
3. **Send command:** `SCAN` to scan for battery
4. **View available commands** - they will be displayed on startup

### Available Commands
- `SCAN` - Scan I2C bus for battery
- `VOLTAGE` - Read basic battery info
- `FULL` - Read full battery diagnostics
- `UNSEAL 0xKEY1 0xKEY2 0xREG [0xOPSTATUS]` - Unseal battery
- `RESET [0xREG]` - Send reset commands
- `STATUS` - Check battery security status

---

## Python Client

For automated testing, use the Python client:

```bash
python host_client_example.py COM3
```

Replace COM3 with your port.

---

## Support

For issues or questions, contact BHR support or refer to the project repository.
